
/*
 * accton add on  board configuration file
 *
 * Please refer to doc/README.mpc85xxcds for more info.
 *
 */
#ifndef __ACCTON_BOARD_H
#define __ACCTON_BOARD_H


#define CONFIG_SYS_BOOT_RAMDISK_HIGH /*move ramdisk to address hint from "initrd_high" environement*/
#define CONFIG_LMB 1

#define CONFIG_LOADADDR 0x81000000
/* High Level Configuration Options */
#define CONFIG_SPI_FLASH_MTD 1
//#define CONFIG_ACCTON_RUNTIME 1 /*move to makefile*/
#define CONFIG_CMD_BDI  1
#define CONFIG_MTD_DEVICE  1
#define CONFIG_MTD_PARTITIONS  1 /*defined in config.in*/
#define CONFIG_CMD_MTDPARTS 1
#define CONFIG_CMD_UBIFS 1
#define CONFIG_CMD_UBI 1
#define CONFIG_LZO   1
#define CONFIG_RBTREE 1
#define CONFIG_CMD_JFFS2



#define CONFIG_SPI_FLASH
#define CONFIG_TURNKEY_SYSINFO 1
/*
 * DDR Setup
 */
#define CFG_DDR_SDRAM_BASE	CONFIG_SYS_SDRAM_BASE	/*  (0x80000000)*/
#define CFG_SDRAM_BASE		CFG_DDR_SDRAM_BASE

//#define SPD_EEPROM_ADDRESS	0x50		/* DDR DIMM */
//#define SPD_EEPROM_CHANNEL      0x4
//#define CFG_EPLD

/*
 * Make sure required options are set
 */
//#ifndef CONFIG_SPD_EEPROM
//#error ("CONFIG_SPD_EEPROM is required by MPC85555CDS")
//#endif

#undef CONFIG_CLOCKS_IN_MHZ

/*
 * Local Bus Definitions
 */

/*
 * FLASH on the Local Bus
 * Two banks, 8M each, using the CFI driver.
 * Boot from BR0/OR0 bank at 0xff00_0000
 * Alternate BR1/OR1 bank at 0xff80_0000
 *
 * BR0, BR1:
 *    Base address 0 = 0xff00_0000 = BR0[0:16] = 1111 1111 0000 0000 0
 *    Base address 1 = 0xff80_0000 = BR1[0:16] = 1111 1111 1000 0000 0
 *    Port Size = 16 bits = BRx[19:20] = 10
 *    Use GPCM = BRx[24:26] = 000
 *    Valid = BRx[31] = 1
 *
 * 0    4    8    12   16   20   24   28
 * 1111 1111 1000 0000 0001 0000 0000 0001 = ff801001    BR0
 * 1111 1111 0000 0000 0001 0000 0000 0001 = ff001001    BR1
 *
 * OR0, OR1:
 *    Addr Mask = 8M = ORx[0:16] = 1111 1111 1000 0000 0
 *    Reserved ORx[17:18] = 11, confusion here?
 *    CSNT = ORx[20] = 1
 *    ACS = half cycle delay = ORx[21:22] = 11
 *    SCY = 6 = ORx[24:27] = 0110
 *    TRLX = use relaxed timing = ORx[29] = 1
 *    EAD = use external address latch delay = OR[31] = 1
 *
 * 0    4    8    12   16   20   24   28
 * 1111 1111 1000 0000 0110 1110 0110 0101 = ff806e65    ORx
 */

#define CFG_BR0_PRELIM		0xFF800801
#define CFG_BR1_PRELIM		0xD0001801

#define	CFG_OR0_PRELIM		0xFF800FF7
#define	CFG_OR1_PRELIM		0xFFC00FF7

#define CFG_FLASH_BASE_1 0xd0000000
/* Boot from real Flash 
 */
#define CFG_FLASH_BANKS_LIST	{CFG_FLASH_BASE}
//#define CFG_MAX_FLASH_BANKS     1		/* number of banks */
//#define CFG_MAX_FLASH_SECT  	64		/* sectors per device */
#define CFG_FLASH_BASE		    0xFF800000	  /* start of FLASH  (8M)	   */ 
#define CFG_FLASH_PROTECTION
#undef	CFG_FLASH_CHECKSUM
#define CFG_FLASH_ERASE_TOUT	120000	/* Flash Erase Timeout (ms) */
#define CFG_FLASH_WRITE_TOUT	500	/* Flash Write Timeout (ms) */

#define CFG_MONITOR_BASE    	TEXT_BASE	/* start of monitor */

#define CFG_FLASH_CFI_DRIVER
#define CFG_FLASH_CFI
#define CFG_FLASH_EMPTY_INFO


#define CFG_EPLD1_BASE1 0xEA010000

/*
 * SDRAM on the Local Bus
 */
#define CFG_LBC_SDRAM_BASE	0xd0000000	/* Localbus SDRAM */
#define CFG_LBC_SDRAM_SIZE	       64		      /* LBC SDRAM is 64MB */

/*
 * Base Register 2 and Option Register 2 configure SDRAM.
 * The SDRAM base address, CFG_LBC_SDRAM_BASE, is 0xf0000000.
 *
 * For BR2, need:
 *    Base address of 0xf0000000 = BR[0:16] = 1111 0000 0000 0000 0
 *    port-size = 32-bits = BR2[19:20] = 11
 *    no parity checking = BR2[21:22] = 00
 *    SDRAM for MSEL = BR2[24:26] = 011
 *    Valid = BR[31] = 1
 *
 * 0    4    8    12   16   20   24   28
 * 1111 0000 0000 0000 0001 1000 0110 0001 = f0001861
 *
 * FIXME: CFG_LBC_SDRAM_BASE should be masked and OR'ed into
 * FIXME: the top 17 bits of BR2.
 */

#define CFG_BR2_PRELIM          0xE0000881

/*
 * The SDRAM size in MB, CFG_LBC_SDRAM_SIZE, is 64.
 *
 * For OR2, need:
 *    64MB mask for AM, OR2[0:7] = 1111 1100
 *		   XAM, OR2[17:18] = 11
 *    9 columns OR2[19-21] = 010
 *    13 rows   OR2[23-25] = 100
 *    EAD set for extra time OR[31] = 1
 *
 * 0    4    8    12   16   20   24   28
 * 1111 1100 0000 0000 0110 1001 0000 0001 = fc006901
 */

#define CFG_OR2_PRELIM		0xFF801100

#define CFG_LBC_LCRR		0x00010004    /* LB clock ratio reg */
#define CFG_LBC_LBCR		0x00000000    /* LB config reg */
#define CFG_LBC_LSRT		0x20000000  /* LB sdram refresh timer */
#define CFG_LBC_MRTPR		0x00000000  /* LB refresh timer prescal*/
#define LBC_UPM_MxMR        0x08466440

/*
 * LSDMR masks
 */
#define CFG_LBC_LSDMR_RFEN	(1 << (31 -  1))
#define CFG_LBC_LSDMR_BSMA1516	(3 << (31 - 10))
#define CFG_LBC_LSDMR_BSMA1617	(4 << (31 - 10))
#define CFG_LBC_LSDMR_RFCR16	(7 << (31 - 16))
#define CFG_LBC_LSDMR_PRETOACT7	(7 << (31 - 19))
#define CFG_LBC_LSDMR_ACTTORW7	(7 << (31 - 22))
#define CFG_LBC_LSDMR_ACTTORW6	(6 << (31 - 22))
#define CFG_LBC_LSDMR_BL8	(1 << (31 - 23))
#define CFG_LBC_LSDMR_WRC4	(0 << (31 - 27))
#define CFG_LBC_LSDMR_CL3	(3 << (31 - 31))

#define CFG_LBC_LSDMR_OP_NORMAL	(0 << (31 - 4))
#define CFG_LBC_LSDMR_OP_ARFRSH	(1 << (31 - 4))
#define CFG_LBC_LSDMR_OP_SRFRSH	(2 << (31 - 4))
#define CFG_LBC_LSDMR_OP_MRW	(3 << (31 - 4))
#define CFG_LBC_LSDMR_OP_PRECH	(4 << (31 - 4))
#define CFG_LBC_LSDMR_OP_PCHALL	(5 << (31 - 4))
#define CFG_LBC_LSDMR_OP_ACTBNK	(6 << (31 - 4))
#define CFG_LBC_LSDMR_OP_RWINV	(7 << (31 - 4))

/*
 * Common settings for all Local Bus SDRAM commands.
 * At run time, either BSMA1516 (for CPU 1.1)
 *                  or BSMA1617 (for CPU 1.0) (old)
 * is OR'ed in too.
 */
#define CFG_LBC_LSDMR_COMMON	( CFG_LBC_LSDMR_RFCR16		\
				| CFG_LBC_LSDMR_PRETOACT7	\
				| CFG_LBC_LSDMR_ACTTORW7	\
				| CFG_LBC_LSDMR_BL8		\
				| CFG_LBC_LSDMR_WRC4		\
				| CFG_LBC_LSDMR_CL3		\
				| CFG_LBC_LSDMR_RFEN		\
				)

/*
 * The CADMUS registers are connected to CS3 on CDS.
 * The new memory map places CADMUS at 0xf8000000.
 *
 * For BR3, need:
 *    Base address of 0xf8000000 = BR[0:16] = 1111 1000 0000 0000 0
 *    port-size = 8-bits  = BR[19:20] = 01
 *    no parity checking  = BR[21:22] = 00
 *    GPMC for MSEL       = BR[24:26] = 000
 *    Valid               = BR[31]    = 1
 *
 * 0    4    8    12   16   20   24   28
 * 1111 1000 0000 0000 0000 1000 0000 0001 = f8000801
 *
 * For OR3, need:
 *    1 MB mask for AM,   OR[0:16]  = 1111 1111 1111 0000 0
 *    disable buffer ctrl OR[19]    = 0
 *    CSNT                OR[20]    = 1
 *    ACS                 OR[21:22] = 11
 *    XACS                OR[23]    = 1
 *    SCY 15 wait states  OR[24:27] = 1111	max is suboptimal but safe
 *    SETA                OR[28]    = 0
 *    TRLX                OR[29]    = 1
 *    EHTR                OR[30]    = 1
 *    EAD extra time      OR[31]    = 1
 *
 * 0    4    8    12   16   20   24   28
 * 1111 1111 1111 0000 0000 1111 1111 0111 = fff00ff7
 */

//#define CADMUS_BASE_ADDR 0xf8000000
#define CFG_BR3_PRELIM   0xEA000801
#define CFG_OR3_PRELIM   0xFFF00FF7

#define CADMUS_BASE_ADDR 0xf8000000
#define CONFIG_L1_INIT_RAM
#define CFG_INIT_RAM_LOCK 	1
#define CFG_INIT_RAM_ADDR	0x40000000	/* Initial RAM address */
#define CFG_INIT_RAM_END    0x4000	    /* End of used area in RAM */

#define CFG_GBL_DATA_SIZE  	512	    /* num bytes initial data */
#define CFG_GBL_DATA_OFFSET	(CFG_INIT_RAM_END - CFG_GBL_DATA_SIZE)
#define CFG_INIT_SP_OFFSET	CFG_GBL_DATA_OFFSET

#define CFG_MONITOR_LEN	    	(512 * 1024) /* Reserve 256 kB for Mon */
#define CFG_MALLOC_LEN	    	(2 * 1024 * 1024)	/* Reserved for malloc */

/* Serial Port */
#define CONFIG_SILENT_CONSOLE

#undef	CONFIG_SERIAL_SOFTWARE_FIFO
#define CFG_NS16550
#define CFG_NS16550_SERIAL
#define CFG_NS16550_REG_SIZE    1
#define CFG_NS16550_CLK		get_bus_freq(0)
#define CFG_BAUDRATE_TABLE  \
	{300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 115200}
//#define CONFIG_BAUDRATE  9600

#define CFG_NS16550_COM1        (CFG_CCSRBAR+0x4500)
#define CFG_NS16550_COM2        (CFG_CCSRBAR+0x4600)

/* Use the HUSH parser */
#define CFG_HUSH_PARSER
#ifdef  CFG_HUSH_PARSER
#define CFG_PROMPT_HUSH_PS2 "> "
#endif

/* pass open firmware flat tree */
#if 0
#define CONFIG_OF_LIBFDT            1
#define CONFIG_OF_BOARD_SETUP       1
#define CONFIG_OF_STDOUT_VIA_ALIAS	1
#endif

/*
 * I2C
 */
#if 0
#define CONFIG_CMD_I2C
#define CONFIG_FSL_I2C		/* Use FSL common I2C driver */
#define CONFIG_HARD_I2C		/* I2C with hardware support*/
#undef	CONFIG_SOFT_I2C			/* I2C bit-banged */
#define CFG_I2C_SPEED		400000	/* I2C speed and slave address */
#define CFG_I2C_EEPROM_ADDR	0x50
#define CFG_I2C_SLAVE		0x70
#define CFG_PCA9548_CH0      0x70
#define CFG_PCA9548_CH1      0x72
#define CFG_PCA9548_CH2      0x73
#define CFG_PCA9548_CH3      0x74

#define CFG_I2C_NOPROBES        {CFG_PCA9548_CH0, CFG_PCA9548_CH1,CFG_PCA9548_CH2,CFG_PCA9548_CH3}	/* Don't probe these addrs */
#define CFG_I2C_OFFSET		0x3000
#endif
/*
 * General PCI
 * Memory space is mapped 1-1, but I/O space must start from 0.
 */
#define CFG_PCI1_MEM_BASE	0x80000000
#define CFG_PCI1_MEM_PHYS	CFG_PCI1_MEM_BASE
#define CFG_PCI1_MEM_SIZE	0x20000000	/* 512M */
#define CFG_PCI1_IO_BASE	0x62000000
#define CFG_PCI1_IO_PHYS	CFG_PCI1_IO_BASE
#define CFG_PCI1_IO_SIZE	0x100000	/* 1M */

#define CFG_PCI2_MEM_BASE	0xa0000000
#define CFG_PCI2_MEM_PHYS	CFG_PCI2_MEM_BASE
#define CFG_PCI2_MEM_SIZE	0x20000000	/* 512M */
#define CFG_PCI2_IO_BASE	0x63000000
#define CFG_PCI2_IO_PHYS	CFG_PCI2_IO_BASE
#define CFG_PCI2_IO_SIZE	0x1000000	/* 1M */

#ifdef CONFIG_LEGACY
#define BRIDGE_ID 17
#define VIA_ID 2
#else
#define BRIDGE_ID 28
#define VIA_ID 4
#endif

#if defined(CONFIG_PCI)

#define CONFIG_PCI_PNP	               	/* do pci plug-and-play */

#undef CONFIG_EEPRO100
#undef CONFIG_TULIP

#undef CONFIG_PCI_SCAN_SHOW		/* show pci devices on startup */
#define CFG_PCI_SUBSYS_VENDORID 0x1057  /* Motorola */

#endif	/* CONFIG_PCI */

#define CONFIG_DOS_PARTITION

#if defined(CONFIG_TSEC_ENET)

#ifndef CONFIG_NET_MULTI
#define CONFIG_NET_MULTI 	1
#endif

#define CONFIG_MII		1	/* MII PHY management */
#define CONFIG_TSEC1	1
#define CONFIG_TSEC1_NAME	"TSEC0"
//#undef CONFIG_TSEC2	1
//#define CONFIG_TSEC2_NAME	"TSEC1"
#define TSEC1_PHY_ADDR		1 
//#define TSEC2_PHY_ADDR		1
#define TSEC1_PHYIDX		0
//#define TSEC2_PHYIDX		0
#define TSEC1_FLAGS		TSEC_GIGABIT
//#define TSEC2_FLAGS		TSEC_GIGABIT

/* Options are: TSEC[0-1] */
#define CONFIG_ETHPRIME		"TSEC0"

#endif	/* CONFIG_TSEC_ENET */
#define CFG_EPLD_BASE_ADDR  0xEA000000

#define SYS_ADPT_LOADER_ADMIN_PASSWORD              "ldhelper"

/*UC Memory */
#define CONFIG_PRAM                                 2048 /* reserve 4 MB "protected RAM" */
#define CONFIG_TOP_MEMORY_RESERVED_SIZE             0x400000 /*2M for uboot memory SPI/reloc...*/
#define CONFIG_AMS_UC_BUFFER_INDEX_NUM              64
#define CONFIG_AMS_UC_MEM_SIZE                      (CONFIG_PRAM << 10)

#define SYS_VAL_COLD_START                          1   /* Cold Start */
#define SYS_VAL_COLD_START_FOR_RELOAD               2   /* Cold Start for apps reload */
#define SYS_VAL_WARM_START_FOR_RELOAD               3   /* Warm Start */
#define SYS_VAL_LOADER_CALLED_BY_DIAG               4   /* After Diag finished, load the run time image */
#define SYS_VAL_WARM_START_FOR_TEMP_DOWNLOAD        5   /* Warm Start for temp download */
#define SYS_VAL_WARM_START_FOR_COPYRUNNING          6   /* Warm Start for copy running config */

#define SYS_VAL_COLDSTART_MAGIC_NUMBER              0x1a2b3c4d   /* Cold Start Magic Number */
#define SYS_VAL_WARMSTART_MAGIC_NUMBER              0xd4c3b2a1   /* Warm Start Magic Number */
#define SYS_VAL_RESTART_MAGIC_NUMBER                0xd8c7b6a5   /* Re-Start Magic Number  support copy file to running operation meiling.hou*/ 

#define ENV_VAR_ITEM_MAX_LEN                        32
#define CONFIG_MAGIC                                0x9e8a6b71
#define CONFIG_PROJECT_ID                           0x1D5
#define CONFIG_BOARD_ID                             0x1
#define CONFIG_HARDWARE_ID                          R0A                 /*Hardware ID         */
#define CONFIG_HARDWARE_VER                         R0A                 /*Hardware version */
#define CONFIG_SERIAL_NUM                           S123456             /*Serial Number      */

#define CONFIG_MANUFACTURE_DATE             2015-01-01

#define CONFIG_MODEL_NUM                    ECS2000-10t
#define CONFIG_MODEL_BITMAP1                0
#define CONFIG_MODEL_BITMAP2                0
#define CONFIG_MODEL_BITMAP3                0
#define CONFIG_MODEL_BITMAP4                0
#define CONFIG_SERVICE_TAG                  tag

#define CONFIG_ETHADDR0		               0x00
#define CONFIG_ETHADDR1                    0xE0
#define CONFIG_ETHADDR2                    0x0C
#define CONFIG_ETHADDR3                    0x00
#define CONFIG_ETHADDR4                    0x00
#define CONFIG_ETHADDR5                    0xFD

/*
 * Environment
 */
#define CFG_FLASH_SECTOR_SIZE	0x20000
#define CFG_ENV_IS_IN_FLASH	1
//#define CFG_ENV_ADDR		(CFG_FLASH_BASE + 0x40000)
#define CFG_ENV_ADDR		0xFF820000      /* shoulde same as partition table's setting */
#define CFG_ENV_SECT_SIZE	CFG_FLASH_SECTOR_SIZE 	/* 256K(one sector) for env */
#define CFG_ENV_SIZE		0x2000

#define CONFIG_LOADS_ECHO	1	/* echo on for serial download */
#define CFG_LOADS_BAUD_CHANGE	1	/* allow baudrate change */
#define CONFIG_ROOTPATH  "/nfsroot"
/*
 * BOOTP options

#define CONFIG_BOOTP_BOOTFILESIZE
#define CONFIG_BOOTP_BOOTPATH
#define CONFIG_BOOTP_GATEWAY
#define CONFIG_BOOTP_HOSTNAME
 */
/*
  * custom macros
  */
#define CONFIG_AMS_UBOOT
#ifdef CONFIG_AMS_UBOOT
#define CONFIG_AMS_COMPACT_FLASH
#define CONFIG_AMS_PARTITION
#define CONFIG_AMS_HWINFO
#define CONFIG_AMS_UCMGR_SHOWLOG
#undef CONFIG_ACCTON_FS
#define CONFIG_ACCTON_MULTI
#undef CONFIG_ACCTON_KERNEL_ROOTFS
#endif

#ifdef CONFIG_AMS_COMPACT_FLASH
#define CONFIG_COMPACT_FLASH
#define CFG_CF_BASE_ADDR    0xE0000000
#define CFG_CF_BASE         0xE0010000
#define CFG_CF_PART_BASE    0x0
#define CFG_CF_PART_MAX     0xC000000
#endif


/*
 * Command line configuration.
 */
//#include <ams_config_cmd_default.h>



#define CONFIG_CMD_MII
//#define CONFIG_CMD_ELF
//#define CONFIG_CMD_FILE
//#define CONFIG_CMD_CF
//#define CONFIG_CMD_EXT2
//#if defined(CONFIG_PCI)
//#define CONFIG_CMD_PCI
//#endif


//#if defined(CONFIG_AMS_PARTITION)
 #define CONFIG_CMD_AMS_PARTITION
//#endif

#if defined(CONFIG_AMS_HWINFO)
    #define CONFIG_CMD_AMS_HWINFO
#endif

#if defined(CONFIG_AMS_COMPACT_FLASH)
    #define CONFIG_CMD_CFON
#endif

#if defined (CONFIG_AMS_UCMGR_SHOWLOG)
    #define CONFIG_CMD_UCMGR_SHOWLOG
#endif

#undef CONFIG_WATCHDOG			/* watchdog disabled */

/*
 * Miscellaneous configurable options
 */
#define CFG_LONGHELP			/* undef to save memory	*/
//#define CONFIG_CMDLINE_EDITING		/* Command-line editing */
#define CFG_LOAD_ADDR	0x1000000	/* default load address */
#define CFG_PROMPT	"LOADER=> "		/* Monitor Command Prompt */
#if defined(CONFIG_CMD_KGDB)
#define CFG_CBSIZE	1024		/* Console I/O Buffer Size */
#else
#define CFG_CBSIZE	256		/* Console I/O Buffer Size */
#endif
#define CFG_PBSIZE (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define CFG_MAXARGS	16		/* max number of command args */
#define CFG_BARGSIZE	CFG_CBSIZE	/* Boot Argument Buffer Size */
#define CFG_HZ		1000		/* decrementer freq: 1ms ticks */

/* jerry.du add for misc_init_f, misc_init_r calling 20080625 */
#define CONFIG_MISC_INIT_F	1	/* Call misc_init_f		*/
//#define CONFIG_MISC_INIT_R	1	/* Call misc_init_r		*/

/*
 * For booting Linux, the board info and command line data
 * have to be in the first 8 MB of memory, since this is
 * the maximum mapped by the Linux kernel during initialization.
 */
#define CFG_BOOTMAPSZ	(8 << 20) 	/* Initial Memory map for Linux*/

/*
 * Internal Definitions
 *
 * Boot Flags
 */
#define BOOTFLAG_COLD	0x01		/* Normal Power-On: Boot from FLASH */
#define BOOTFLAG_WARM	0x02		/* Software reboot */

#if defined(CONFIG_CMD_KGDB)
#define CONFIG_KGDB_BAUDRATE	230400	/* speed to run kgdb serial port */
#define CONFIG_KGDB_SER_INDEX	2	/* which serial port to use */
#endif

/*
 * Environment Configuration
 */

/* The mac addresses for all ethernet interface */
#if defined(CONFIG_TSEC_ENET)
#define CONFIG_HAS_ETH0
//#define CONFIG_ETHADDR   00:E0:0C:00:00:FD
#define CONFIG_HAS_ETH1
#define CONFIG_ETH1ADDR  00:E0:0C:00:01:FD
#define CONFIG_HAS_ETH2
#define CONFIG_ETH2ADDR  00:E0:0C:00:02:FD
#endif

//#define CONFIG_IPADDR    192.168.2.10

#define CONFIG_HOSTNAME  unknown

//#define CONFIG_BOOTFILE  your.uImage

//#define CONFIG_SERVERIP  192.168.2.99
//#define CONFIG_GATEWAYIP 192.168.2.99
//#define CONFIG_NETMASK   255.255.255.0

//#define CONFIG_LOADADDR  0x1000000   /*default location for tftp and bootm*/

//#define CONFIG_BOOTDELAY 10          /* -1 disables auto-boot */
//#define CONFIG_BOOTARGS  "root=/dev/ram rw console=ttyS0,9600 mem=500M"

#define CONFIG_LOADER_HEADER_LEN      0x3c      /*sizeof LDR_INFO_BLOCK */



/*
  * Default partition setting
  */
#define PART0_NAME          "uboot"
#define PART0_BASE_ADDR     0x0
#define PART0_SIZE          0x00100000

#define PART1_NAME          "env"
#define PART1_BASE_ADDR     0x00100000
#define PART1_SIZE          0x00080000

#define PART2_NAME          "hwinfo"
#define PART2_BASE_ADDR     0x00180000
#define PART2_SIZE          0x00080000

#define PART3_NAME          "userdata"
#define PART3_BASE_ADDR     0x00200000
#define PART3_SIZE          0x01E00000

#define MTDIDS_DEFAULT     "nor0=spi0.0"
//#define MTDPARTS_DEFAULT   "mtdparts=spi0.0:1024k(uboot),1024k(env),4096k(hwinfo),17408k(mfg),20480k(recovery),-(runtime)"
#define MTDPARTS_DEFAULT   "mtdparts=spi0.0:1024k(uboot),512k(env),512k(hwinfo),-(userdata)"

#define CONFIG_ENV_PART_BASE_ADDR        PART1_BASE_ADDR
#define CONFIG_ENV_PART_SIZE             PART1_SIZE

#define CONFIG_HWINFO_PART_BASE_ADDR     PART2_BASE_ADDR
#define CONFIG_HWINFO_PART_SIZE          PART2_SIZE
#define CONFIG_USERDATA_PART_BASE_ADDR   PART3_BASE_ADDR
#define CONFIG_USERDATA_PART_SIZE        PART3_SIZE


//overwrite default partition
#undef  LOADER_BDINFO_START
#define LOADER_BDINFO_START CONFIG_ENV_PART_BASE_ADDR
#undef  LOADER_BDINFO_SIZE
#define LOADER_BDINFO_SIZE UNIT_SIZE*2
#undef  SYSINFO_START
#define SYSINFO_START (LOADER_BDINFO_START+UNIT_SIZE*2)
#undef  JFFS2_CFG_START
#undef  JFFS2_LOG_START
#undef  KERNEL_START


#define PARTITION_MANAGEMENT_INDEX          1
#define PARTITION_MANAGEMENT_NAME           PART1_NAME
#define PARTITION_MANAGEMENT_BASE_ADDR      PART1_BASE_ADDR
#define PARTITION_MANAGEMENT_SIZE           PART1_SIZE

#define	CONFIG_EXTRA_ENV_SETTINGS				    \
    "netdev=eth0\0"                                 \
    "consoledev=ttyS0\0"                            \
    "acctonruntime=1\0"

#define CONFIG_NFSBOOTCOMMAND	                                        \
    "setenv bootargs root=/dev/nfs rw "                                 \
    "nfsroot=$serverip:$rootpath "                                      \
    "ip=$ipaddr:$serverip:$gatewayip:$netmask:$hostname:$netdev:off "   \
    "console=$consoledev,$baudrate $othbootargs;"                       \
    "tftp $loadaddr $bootfile;"                                         \
    "tftp $fdtaddr $fdtfile;"						                    \
    "bootm $loadaddr - $fdtaddr"

#define CONFIG_RAMBOOTCOMMAND \
    "setenv bootargs root=/dev/ram rw "                                  \
    "console=$consoledev,$baudrate $othbootargs;"                        \
    "tftp $ramdiskaddr $ramdiskfile;"                                    \
    "tftp $loadaddr $bootfile;"                                          \
    "bootm $loadaddr $ramdiskaddr"     

//#define CONFIG_BOOTCOMMAND  "ams_bootm"
#define PART_UBIFS_NAME          "runtime"
#define VOLUMN_UBIFS_NAME        "userdata"
#define FILE_NAME_PREFIX         ".fs/"
#define FILEMAPPING_FILE_NAME    ".fmapping"

#define CONFIG_RUNTIME_LOADADDR  0x81000000
#define CONFIG_ETHADDR_STRING           "CONFIG_ETHADDR"
#define CONFIG_MAX_CPUS 1
#ifdef CONFIG_BOOTCOMMAND
#undef CONFIG_BOOTCOMMAND
//#define CONFIG_BOOTCOMMAND              "acc boot"  /* UBoot command issued on power up */
#endif
#ifdef CONFIG_BOOTARGS
#undef CONFIG_BOOTARGS
//#define CONFIG_BOOTARGS     "root=/dev/ram rw console=ttyS1,115200n8 maxcpus=1 mem=220M envaddr=0x28100000 mtdparts "MTDPARTS_DEFAULT
#endif
//#define CONFIG_BOOTARG_CMD  "setenv bootargs "CONFIG_BOOTARGS
#define LA_LOADER_BACKDOOR_PASSWORD_ENCRYPT     "melzlntn"      /* backdoor password, for using backdoor file manager */
#define LA_MAX_PASSWORD_LENGTH          100
#define FS_HWINFO_CAPABILITY_CHANGE_LOADER_BACKDOOR_PASSWORD (1<<0)
#define LA_LOADER_PRIVILEGED_MODE_PASSWORD_ENCRYPT     "melzui5r" /* privileged password, for using privileged commad manager */
#define CONFIG_USR_PRIVILEGED_MODE
#endif	/* __ACCTON_BOARD_H */

